import { View } from "react-native";
import React from "react";
import AddNewAddressBtn from "../../../../ShoppingCart/BillingInformation/AddNewAddressBtn";
import AddressSkeleton from "../../../../../src/skeletons/screens/profile/AddressSkeleton";
import OrderAddresses from "../../../../ShoppingCart/BillingInformation/OrderAddresses";
import { useDispatch, useSelector } from "react-redux";
import BackNavigation from "../../../../Utilities/CustomHeader/BackNavigation";
import { useNavigation } from "@react-navigation/native";
import CommonStyles from "../../../../Utilities/CommonStyles/CommonStyles";
import {
    setActiveId,
    setDeliveryAddress,
} from "../../../../../redux/slices/featureProducts/deliveryOption/getShipping";
import useLangTranslation from "../../../../../hooks/useLangTranslation";

const SelectDeliveryAddress = () => {
    const { trans } = useLangTranslation();
    const { myAddresses, loading: myAddressLoading } = useSelector(
        (state) => state.getMyAddress
    );
    const navigation = useNavigation();
    const dispatch = useDispatch();
    const { activeId } = useSelector((state) => state.getShippingReducer);

    const handleSelect = (item) => {
        dispatch(setDeliveryAddress(item));
        dispatch(setActiveId(item?.id));
        navigation.goBack();
    };
    return (
        <>
            <View style={CommonStyles.globalContainer}>
                <BackNavigation
                    navigationProps={navigation}
                    routeName={trans("Select Address")}
                    capitalize={true}
                />
                <AddNewAddressBtn />
                {myAddressLoading ? (
                    <AddressSkeleton />
                ) : (
                    <OrderAddresses
                        addresses={myAddresses}
                        borderColor={activeId}
                        handleSelectAddress={handleSelect}
                    />
                )}
            </View>
        </>
    );
};

export default SelectDeliveryAddress;
